<?php namespace App\Controllers\Configuracoes;

 use App\Models\UsuarioModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Usuario extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            return redirect()->to('/Login');
        }
        $this->usuarioModel = new UsuarioModel();
        $this->auth = new Auth();
        helper('complementos'); 
    }

    public function usuarioConsultar(){
        if($this->auth->CheckAuth(2)){
            $dados = array();
            $dados['resultados'] = $this->usuarioModel->getUsuarios();
            echo view('Commons/header');	
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));	
            echo view('Configuracoes/Usuario/usuario', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function usuarioInserir(){
        if($this->auth->CheckAuth(3)){
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Configuracoes/Usuario/usuario_cadastro');
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function usuarioStore(){
        $dados = array();
        $id = $this->request->getPost('usuario_id');
        if($id == ""){
            $dados['NOME'] = $this->request->getPost('usuario_nome');
            $dados['USUARIO'] = $this->request->getPost('usuario_login');
            $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
            $dados['EMAIL'] = $this->request->getPost('usuario_email');
            $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
            $dados['ATIVO'] = $this->request->getPost('usuario_status');

            if($_FILES['usuario_foto']['tmp_name']!=''){
				$errors= array();
				$file_name = "user_logo_".uniqid();
				$file_size =$_FILES['usuario_foto']['size'];
				$file_tmp =$_FILES['usuario_foto']['tmp_name'];
				$file_type=$_FILES['usuario_foto']['type'];
				$tmp = explode('.',$_FILES['usuario_foto']['name']);
				$file_ext=strtolower(end($tmp));
				
				$extensions= array("jpeg","jpg","png");
				
				if(in_array($file_ext,$extensions)=== false){
				   $errors[]="a foto deve possuir extensão .png ou .jpg";
				}
				
				if($file_size > 2097152){
				   $errors[]='O tamanho da imagem não deve exceder 2MB';
				}
				
				if(empty($errors)==true){
					helper('cloudinary');
					$upload = do_upload($file_tmp, $file_name);
					$dados['URL_FOTO'] = $upload['url'];
				}else{
					return redirect()->to('/Configuracoes/Usuario/usuarioConsultar?tipo_msg=erro&msg=Erro ao carregar imagem, verifique o tamanho e a extensão!');
                }
            }
            
            if($this->usuarioModel->setUsuario($dados)){
                return redirect()->to('/Configuracoes/Usuario/usuarioConsultar?tipo_msg=sucesso&msg=Ação realizada!');
            }else{
                return redirect()->to('/Configuracoes/Usuario/usuarioConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
            }
        }else{
            $dados['ID_USUARIO'] = $this->request->getPost('usuario_id');
            $dados['NOME'] = $this->request->getPost('usuario_nome');
            $dados['USUARIO'] = $this->request->getPost('usuario_login');
            $dados['EMAIL'] = $this->request->getPost('usuario_email');
            $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
            $dados['ATIVO'] = $this->request->getPost('usuario_status');

            if($_FILES['usuario_foto']['tmp_name']!=''){
				$errors= array();
				$file_name = "user_logo_".uniqid();
				$file_size =$_FILES['usuario_foto']['size'];
				$file_tmp =$_FILES['usuario_foto']['tmp_name'];
				$file_type=$_FILES['usuario_foto']['type'];
				$tmp = explode('.',$_FILES['usuario_foto']['name']);
				$file_ext=strtolower(end($tmp));
				
				$extensions= array("jpeg","jpg","png");
				
				if(in_array($file_ext,$extensions)=== false){
				   $errors[]="a foto deve possuir extensão .png ou .jpg";
				}
				
				if($file_size > 2097152){
				   $errors[]='O tamanho da imagem não deve exceder 2MB';
				}
				
				if(empty($errors)==true){
					helper('cloudinary');
					$upload = do_upload($file_tmp, $file_name);
					$dados['URL_FOTO'] = $upload['url'];
				}else{
					return redirect()->to('/Configuracoes/Usuario/usuarioConsultar?tipo_msg=erro&msg=Erro ao carregar imagem, verifique o tamanho e a extensão!');
                }
                
            }

            if($this->request->getPost('perfil')=="true"){
                $dados = array();
                $dados['NOME'] = $this->request->getPost('usuario_nome');
                $dados['USUARIO'] = $this->request->getPost('usuario_login');
                $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha')));
                $dados['EMAIL'] = $this->request->getPost('usuario_email');
                $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');

                if($_FILES['usuario_foto']['tmp_name']!=''){
                    $errors= array();
                    $file_name = "user_logo_".uniqid();
                    $file_size =$_FILES['usuario_foto']['size'];
                    $file_tmp =$_FILES['usuario_foto']['tmp_name'];
                    $file_type=$_FILES['usuario_foto']['type'];
                    $tmp = explode('.',$_FILES['usuario_foto']['name']);
                    $file_ext=strtolower(end($tmp));
                    
                    $extensions= array("jpeg","jpg","png");
                    
                    if(in_array($file_ext,$extensions)=== false){
                    $errors[]="a foto deve possuir extensão .png ou .jpg";
                    }
                    
                    if($file_size > 2097152){
                    $errors[]='O tamanho da imagem não deve exceder 2MB';
                    }
                    
                    if(empty($errors)==true){
                        helper('cloudinary');
                        $upload = do_upload($file_tmp, $file_name);
                        $dados['URL_FOTO'] = $upload['url'];
                    }else{
                        return redirect()->to('/Configuracoes/Usuario/usuarioConsultar?tipo_msg=erro&msg=Erro ao carregar imagem, verifique o tamanho e a extensão!');
                    }
                    
                }
            }
            
            if($this->usuarioModel->updateUsuario($dados)){
                return redirect()->to('/Configuracoes/Usuario/usuarioConsultar?tipo_msg=sucesso&msg=Ação realizada!');
            }else{
                return redirect()->to('/Configuracoes/Usuario/usuarioConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
            }
        }
    }

    public function usuarioEditar($id=""){
        if($this->auth->CheckAuth(4)){
            $dados['usuario'] = $this->usuarioModel->getUsuarioID(base64_decode($id));
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Configuracoes/Usuario/usuario_cadastro', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function usuarioPerfil($id=""){
        if($this->usuario['ID_USUARIO'] == base64_decode($id)){
            $dados['usuario'] = $this->usuarioModel->getUsuarioID(base64_decode($id));
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Configuracoes/Usuario/usuario_perfil', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function UsuarioVerificar(){
        echo json_encode($this->usuarioModel->usuarioVerificar($this->request->getPost('usuario')));
    }
}