<?php namespace App\Controllers;

use App\Models\UsuarioModel;
use CodeIgniter\Controller;

class Login extends BaseController
{

	public function __construct(){
		$this->usuarioModel = new UsuarioModel();
		$this->session = \Config\Services::session();
    }

	public function index()
	{

		$usuario = $this->session->get('dadoslogin');
        if(isset($usuario)){
            return redirect()->to('/Home');
        }else{
			echo view('Commons/header_login');
			echo view('Login/login');
			echo view('Commons/footer_login');
		}
		
	}

	//--------------------------------------------------------------------

	public function validaLogin(){
        $login = $this->usuarioModel->getInformacoesLogin(strtoupper($this->request->getPost('username')), sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('password')))); //Verifica as informações de Login
        if(!empty($login)){	
			$dadosuser['dadoslogin'] = $login[0];	
			$this->session->set($dadosuser); //Se o login existir, seta as informações retornadas pela query em uma sessão.
			/** SALVA LOG DE ACESSO */
			$log['FK_ID_USUARIO'] = $dadosuser['dadoslogin']['ID_USUARIO'];
			$log['DATA'] = date('Y-m-d H:i:s');
			$this->usuarioModel->setLogAcess($log);
            return redirect()->to('/Home'); //redireciona para a página principal do sistema
        }else{
			$dados = array('errologin' => 'Usuario ou senha estão incorretos'); // Se o login não existir retorna um erro para view.
			/* Carrega as views*/
            echo view('Commons/header_login');
			echo view('Login/login', $dados);
			echo view('Commons/footer_login');
        }
	}
	
	public function sair(){
		//Destroi a sessão atual no navegador do usuario.
		$this->session->destroy();
		//chama o metodo (tela) de login
		return redirect()->to('/');
	}

}
