/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var base_url = window.location.origin + "/";
  var table = $('#analises').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    "pageLength": 50,
    scrollX: true
  });

  $('#analises tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  $('#gravar_solicitacao').click(function () {
    $('#frmSolicitacoes_cadastro').submit();
  });

  /** Design da tela */

  /* Esconde os elementos da tela */

  $('.fisica').hide();
  $('.juridica').hide();

  $('#solicitacoes_tipo').on('change', function () {
    var tipo = $(this).val();
    if (tipo == "F") {
      /** Exibindo campos pessoa física */
      $('.juridica').hide();
      $('.fisica').show();
      /* Adicionando regras de validação*/
      $(".juridica").prop("disabled", true);
      $(".fisica").prop("disabled", false);
    }
    if (tipo == "J") {
      /** Exibindo campos pessoa jurídica */
      $('.fisica').hide();
      $('.juridica').show();
      /* Adicionando regras de validação*/
      $(".fisica").prop("disabled", true);
      $(".juridica").prop("disabled", false);
    }

    if (tipo == "") {
      $('.fisica').hide();
      $('.juridica').hide();
    }
  });

  /**Carregamento campos em edição obs:não precisa de click */

  var tipo = $('#solicitacoes_tipo').val();
  if (tipo == "F") {
    /** Exibindo campos pessoa física */
    $('.juridica').hide();
    $('.fisica').show();
    /* Adicionando regras de validação*/
    $(".juridica").prop("disabled", true);
    $(".fisica").prop("disabled", false);
  }
  if (tipo == "J") {
    /** Exibindo campos pessoa jurídica */
    $('.fisica').hide();
    $('.juridica').show();
    /* Adicionando regras de validação*/
    $(".fisica").prop("disabled", true);
    $(".juridica").prop("disabled", false);
  }

  /** Webservice VIACEP */

  $("#solicitacoes_cep").blur(function () {
    //Nova variável "cep" somente com dígitos.
    var cep = $(this).val().replace(/\D/g, '');

    //Verifica se campo cep possui valor informado.
    if (cep != "") {

      //Expressão regular para validar o CEP.
      var validacep = /^[0-9]{8}$/;

      //Valida o formato do CEP.
      if (validacep.test(cep)) {

        //Preenche os campos com "..." enquanto consulta webservice.
        $("#solicitacoes_logradouro").val("...");
        $("#solicitacoes_bairro").val("...");
        $("#solicitacoes_cidade").val("...");
        $("#solicitacoes_uf").val("...");
        $("#solicitacoes_ibge").val("...");

        //Consulta o webservice viacep.com.br/
        $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

          if (!("erro" in dados)) {
            //Atualiza os campos com os valores da consulta.
            $("#solicitacoes_logradouro").val(dados.logradouro);
            $("#solicitacoes_bairro").val(dados.bairro);
            $("#solicitacoes_cidade").val(dados.localidade);
            $("#solicitacoes_uf").val(dados.uf);
            $("#solicitacoes_ibge").val(dados.ibge);
          } //end if.
          else {
            //CEP pesquisado não foi encontrado.
            swal("Erro!",
              "CEP não encontrado!")
          }
        });
      } //end if.
      else {
        //cep é inválido.
        swal("Erro!",
          "CEP inválido!")
      }
    } //end if.
  });


  /** Editar CPF e CNPJ se já houver na base de dados 
  $('#solicitacoes_cpf').blur(function () {
    var cpf = $(this).val();
    $.ajax({
      type: "POST",
      url: base_url + 'Cadastros/Clientes/clientesVerificarCPF_CNPJ',
      data: {
        'cpf_cnpj': cpf,
      },
      dataType: 'json',
      success: function (data) {
        if (data.length > 0) {
          if ($('#solicitacoes_id').val() != "") {
            if ($('#solicitacoes_id').val() != data[0].ID_PESSOA) {
              swal({
                title: "CPF Encontrado",
                text: "O CPF informado já existe na base de dados, deseja editá-lo?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#1E9FF2",
                confirmButtonText: "Sim, desejo editar!",
                cancelButtonText: "Não, cancele!",
                closeOnConfirm: true,
                closeOnCancel: false
              }, function (isConfirm) {
                if (isConfirm) {
                  window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
                } else {
                  swal("Cancelado", "Operação cancelada!", "error");
                  $('#solicitacoes_cpf').val("");
                }
              });
            }
          } else {
            swal({
              title: "CPF Encontrado",
              text: "O CPF informado já existe na base de dados, deseja editá-lo?",
              type: "warning",
              showCancelButton: true,
              confirmButtonColor: "#1E9FF2",
              confirmButtonText: "Sim, desejo editar!",
              cancelButtonText: "Não, cancele!",
              closeOnConfirm: true,
              closeOnCancel: false
            }, function (isConfirm) {
              if (isConfirm) {
                window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
              } else {
                swal("Cancelado", "Operação cancelada!", "error");
                $('#solicitacoes_cpf').val("");
              }
            });
          }
        }
      }
    });
  });*/

  $('#solicitacoes_cnpj').blur(function () {
    var cnpj = $(this).val().replace(/\D/g, '');
    $.ajax({
      type: "POST",
      url: base_url + 'Cadastros/Clientes/clientesVerficarCPF_CNPJ',
      data: {
        'cpf_cnpj': cnpj,
      },
      dataType: 'json',
      success: function (data) {
        if (data.length > 0) {
          if ($('#solicitacoes_id').val() != "") {
            if ($('#solicitacoes_id').val() != data[0].ID_PESSOA) {
              swal({
                title: "CNPJ Encontrado",
                text: "O CNPJ informado já existe na base de dados, deseja editá-lo?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#1E9FF2",
                confirmButtonText: "Sim, desejo editar!",
                cancelButtonText: "Não, cancele!",
                closeOnConfirm: true,
                closeOnCancel: false
              }, function (isConfirm) {
                if (isConfirm) {
                  window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
                } else {
                  swal("Cancelado", "Operação cancelada!", "error");
                  $('#solicitacoes_cnpj').val("");
                }
              });
            } else {

            }
          } else {
            swal({
              title: "CNPJ Encontrado",
              text: "O CNPJ informado já existe na base de dados, deseja editá-lo?",
              type: "warning",
              showCancelButton: true,
              confirmButtonColor: "#1E9FF2",
              confirmButtonText: "Sim, desejo editar!",
              cancelButtonText: "Não, cancele!",
              closeOnConfirm: true,
              closeOnCancel: false
            }, function (isConfirm) {
              if (isConfirm) {
                window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
              } else {
                swal("Cancelado", "Operação cancelada!", "error");
                $('#solicitacoes_cnpj').val("");
              }
            });
          }
        }
      }
    });
  });

  $('#solicitacoes_razao_social').focus(function (event) {
    var cnpj = $('#solicitacoes_cnpj').val().replace(/\D/g, '');
    $.ajax({
      url: 'https://www.receitaws.com.br/v1/cnpj/' + cnpj + '',
      type: 'GET',
      crossDomain: true,
      dataType: 'jsonp',
      success: function (dados) {
        $('#solicitacoes_razao_social').val(dados.nome);
        $('#solicitacoes_nome_fantasia').val(dados.fantasia);
        $('#solicitacoes_cidade').val(dados.municipio);
        $('#solicitacoes_uf').val(dados.uf);
        $('#solicitacoes_logradouro').val(dados.logradouro);
        $('#solicitacoes_numero').val(dados.numero);
        $('#solicitacoes_bairro').val(dados.bairro);
        $('#solicitacoes_cep').val(dados.cep);
        var cep = dados.cep.replace(/\D/g, '');
        $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (data) {

          if (!("erro" in data)) {
            //Atualiza os campos com os valores da consulta.
            $("#solicitacoes_ibge").val(data.ibge);
          } //end if.
          else {
            //CEP pesquisado não foi encontrado.
            swal("Erro!",
              "CEP não encontrado!")
          }
        });
        $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

          if (!("erro" in dados)) {
            deleteMarkers();
            addMarker(dados.results[0].geometry.location);
            addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
          }
        });
        $('#solicitacoes_email').val(dados.email);
        $('#solicitacoes_telefone01').val(dados.telefone);
      }
    });
  });

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });

  $('#solicitacoes_cep').blur(function () {
    if ($('#solicitacoes_cep').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_cidade').blur(function (event) {
    if ($('#solicitacoes_cidade').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_uf').blur(function (event) {
    if ($('#solicitacoes_uf').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_logradouro').blur(function (event) {
    if ($('#solicitacoes_logradouro').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_numero').blur(function (event) {
    if ($('#solicitacoes_numero').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  var geocode = $('#geocode').val();

  if (geocode != null && geocode != "") {
    $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?latlng=" + geocode + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

      if (!("erro" in dados)) {
        //Adicionar marcador no maps
        addMarker(dados.results[0].geometry.location);
      } //end if.
      else {
        alert('erro ao carregar mapa');
        //CEP pesquisado não foi encontrado.
      }
    });
  }

  $('#gravar_info').click(function () {
    $.ajax({
      type: "POST",
      url: base_url + 'Orcamento/Solicitacoes/setInformacoesProj',
      data: {
        'id': $('#id').val(),
        'msg': $('#solicitacoes_detalhes').val(),
      },
      dataType: 'json',
      success: function (data) {
        if (data.msg == "sucesso") {
          swal({
            title: "Sucesso",
            type: "success",
            confirmButtonText: "Ok",
            text: "Informação salva!",
          });
        } else {
          swal("Erro", "Erro ao salvar informação!", "error");
        }
      }
    });
  });

  Dropzone.options.myDropzone = {
    init: function () {
      this.on("addedfile", function (file) {
        // Create the remove button
        var removeButton = Dropzone.createElement("<button class='btn btn-sm btn-block'>Remove file</button>");

        // Capture the Dropzone instance as closure.
        var _this = this;

        // Listen to the click event
        removeButton.addEventListener("click", function (e) {
          // Make sure the button click doesn't submit the form:
          e.preventDefault();
          e.stopPropagation();

          // Remove the file preview.
          _this.removeFile(file);
          // If you want to the delete the file on the server as well,
          // you can do the AJAX request here.
        });

        // Add the button to the file preview element.
        file.previewElement.appendChild(removeButton);
      });
    }
  }

  $("#analises button").click(function () {
    var classe = $(this).attr('class');
    if (classe == "btn bg-red btn-list-icon") {
      var id = $(this).attr('id');
      Swal.fire({
        title: 'Selecione uma opção',
        input: 'select',
        inputOptions: {
          '2': 'Negado'
        },
        inputPlaceholder: 'Escolha uma opção',
        showCancelButton: true,
        inputValidator: function (value) {
          return new Promise(function (resolve, reject) {
            if (value !== '') {
              resolve();
            } else {
              resolve('Nenhum status selecionado');
            }
          });
        }
      }).then(function (result) {
        if (result.value) {
          $.ajax({
            type: "POST",
            url: base_url + 'Orcamento/Analises/alterarStatus',
            data: {
              'id': id,
              'status': result.value
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Status alterado!",
                }, function () {
                  location.reload();
                });
              } else if (data.msg == "prop") {
                swal("Erro", "Nenhuma proposta fechada!", "error");
              } else {
                swal("Erro", "Erro ao excluir!", "error");
              }
            }
          });
        }
      });
    } else if (classe == "btn bg-green btn-list-icon") {
      var id = $(this).attr('id');
      swal({
        title: "Deseja continuar?",
        text: "Ao confirmar, será gerado a comissão e posteriormente não será possível alterar?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, desejo validar!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          $.ajax({
            type: "POST",
            url: base_url + 'Orcamento/Analises/validarContrato',
            data: {
              'id': id
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Comissão gerada, contrato validado!",
                }, function () {
                  location.reload();
                });
              } else if (data.msg == "prop") {
                swal("Erro", "Nenhuma simulação de comissão gerada!", "error");
              } else {
                swal("Erro", "Erro ao gerar comissão!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada!", "error");
        }
      });
    } else if (classe == "btn bg-red btn-list-icon excluir") {
      var id = $(this).attr('id');
      swal({
        title: "Deseja continuar?",
        text: "Ao confirmar, será excluído o registro?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, desejo excluir!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          $.ajax({
            type: "POST",
            url: base_url + 'Orcamento/Solicitacoes/excluirSolicitacao',
            data: {
              'id': id
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Solicitacao excluida!",
                }, function () {
                  location.reload();
                });
              } else {
                swal("Erro", "Erro ao excluir!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada!", "error");
        }
      });
    }
  });

  $('#validar_comissao').click(function () {
    $('#linha_comissao .row').remove();
    var entrada = $('#propostas_vl_entrada').val();
    if (entrada != "" && entrada != 0) {
      $('#linha_comissao').append('<div class="row">' +
        '<div class="col-md-3">' +
        '<h5>Valor entrada<span class="text-danger">*</span></h5>' +
        '<div class="controls">' +
        '<input type="text" class="form-control val" id="valor[]" name="valor[]" value="' + entrada + '"> ' +
        '</div>' +
        '<p class="help-block">Valor total entrada</p>' +
        '</div>' +
        '<div class="col-md-4">' +
        '<div class="form-group">' +
        '<h5>Data pagamento comissão</h5>' +
        '<div class="controls">' +
        '<input type="text" class="form-control data" id="data[]" name="data[]">' +
        '</div>' +
        '<p class="help-block">Data para pagamento da comissão</p>' +
        '</div>' +
        '</div>' +
        '</div>');

      mascaras();
    }
    var parcelas = $('#propostas_parcela').val();
    var valor_parcela = $('#propostas_vl_parcela').val();
    if (parcelas != "" && parcelas != 0) {
      for (var i = 1; i <= parcelas; i++) {
        $('#linha_comissao').append('<div class="row">' +
          '<div class="col-md-3">' +
          '<h5>Valor parcela ' + i + '<span class="text-danger">*</span></h5>' +
          '<div class="controls">' +
          '<input type="text" class="form-control val" id="valor[]" name="valor[]" value="' + valor_parcela + '"> ' +
          '</div>' +
          '<p class="help-block">Valor total parcela</p>' +
          '</div>' +
          '<div class="col-md-4">' +
          '<div class="form-group">' +
          '<h5>Data pagamento comissão - Parcela ' + i + '</h5>' +
          '<div class="controls">' +
          '<input type="text" class="form-control data" id="data[]" name="data[]">' +
          '</div>' +
          '<p class="help-block">Data para pagamento da comissão</p>' +
          '</div>' +
          '</div>');

        mascaras();
      }
    }
    var vista = $('#propostas_vl_vista').val();
    if (vista != "" && vista != 0) {
      $('#linha_comissao').append('<div class="row">' +
        '<div class="col-md-3">' +
        '<div class="form-group">' +
        '<h5>Valor à vista<span class="text-danger">*</span></h5>' +
        '<div class="controls">' +
        '<input type="text" class="form-control val" id="valor[]" name="valor[]" value="' + vista + '"> ' +
        '</div>' +
        '<p class="help-block">Valor total à vista</p>' +
        '</div>' +
        '</div>' +
        '<div class="col-md-4">' +
        '<div class="form-group">' +
        '<h5>Data pagamento comissão</h5>' +
        '<div class="controls">' +
        '<input type="text" class="form-control data" id="data[]" name="data[]">' +
        '</div>' +
        '<p class="help-block">Data para pagamento da comissão</p>' +
        '</div>' +
        '</div>' +
        '</div>' +
        '</div>');

      mascaras();
    }

    $('#linha_comissao').append('<div class="row" style="text-align: right; margin-top:10px;">' +
      '<div class="col-md-12">' +
      '<button type="button" id="validar_geracao" class="btn btn-sm bg-green"><span class="fa fa-check"> Validar comissão</span></button>' +
      '</div>' +
      '</div>');

    $('#validar_geracao').click(function () {
      swal({
        title: "Deseja salvar?",
        text: "Verifique todas as informações antes de confirmar!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, pode salvar!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: false,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          var comissao = $('#propostas_comissao').val();
          var id = $('#id_solicitacao').val();
          //fazendo for na classe produto para trazer todos os valores da tabela.
          var i, linhasDaTabela = new Array();
          for (i = 0; i < $('.data').length; i++) {
            linhasDaTabela[i] = new Object();
            linhasDaTabela[i].data = $('.data')[i].value;
            linhasDaTabela[i].val = $('.val')[i].value;
          }
          $.ajax({
            url: base_url + 'Orcamento/Analises/validarComissao',
            type: 'POST',
            dataType: 'json',
            data: {
              'id': id,
              'comissao': comissao,
              'arr': linhasDaTabela
            },
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Previsão adicionada!",
                }, function () {
                  location.reload();
                });
              } else {
                swal("Erro", "Erro ao adicionar previsão!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada!", "error");
        }

      })
    });
  });

  function mascaras() {
    $('.data').inputmask('99/99/9999');
  }
};
