/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var table = $('#parcerias').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    "pageLength": 50,
    scrollX: true
  });

  $('#parcerias button').click(function () {
    var textarea = '<form> <div class=""> <textarea placeholder="Informe o motivo" class="form-control" id="motivo" rows="8"></textarea> </div></form>';
    var motivo;
    var classe = $(this).attr('class');
    if (classe == "btn btn-danger btn-list-icon") {
      $('#id_parceiro').val($(this).attr('id'));
      var idParceria = $('#id_parceiro').val();
    }
    swal({
        title: "Informe o motivo da não aceitação de parceria:",
        text: textarea,
        type: "warning",
        html: true,
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Salvar",
        cancelButtonText: "Cancelar",
        closeOnConfirm: false,
        closeOnCancel: true
      }, // Function that validates email address through a regular expression.
      function (isConfirm) {
        if (isConfirm) {
          motivo = $("#motivo").val();
          //Capturando valor do id da carteira de cobrança selecionada
          if (motivo == "" || motivo == null) {
            swal("Aviso", "Motivo não preenchido!", "warning");
          }
          $.ajax({
            type: "POST",
            url: base_url + 'Cadastros/Parcerias/parceriasInvalidar',
            data: {
              'idParceria': idParceria,
              'motivo': motivo
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Ação realizada!",
                }, function () {
                  location.reload();
                });
              } else if (data.msg == "erro") {
                swal("Erro", "Erro ao realizar a ação!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
        }

      }
    );
  });


  $('#parcerias a button').click(function () {
    var classe = $(this).attr('class');
    if (classe == "btn btn-success btn-list-icon") {
      $('#id_parceiro').val($(this).attr('id'));
      $('#setor').val($(this).attr('value'));
      var idParceria = $('#id_parceiro').val();
      var setor = $('#setor').val();
    }
    if (setor != "RCO" && setor != "VEX") {
      swal({
          title: "Percentual",
          text: "informe o percentual de comissão",
          type: "input",
          showCancelButton: true,
          closeOnConfirm: false,
          inputPlaceholder: "Digite o percentual"
        }, // Function that validates email address through a regular expression.
        function (inputValue) {
          if (inputValue == "" || inputValue == null) {
            swal("Aviso", "Percentual não preenchido!", "warning");
          } else {
            $.ajax({
              type: "POST",
              url: base_url + 'Cadastros/Parcerias/parceriasValidar',
              data: {
                'idParceria': idParceria,
                'percentual': inputValue
              },
              dataType: 'json',
              success: function (data) {
                if (data.msg == "sucesso") {
                  swal({
                    title: "Sucesso",
                    type: "success",
                    confirmButtonText: "Ok",
                    text: "Ação realizada!",
                  }, function () {
                    window.location.href = base_url + "Configuracoes/Permissoes/permissoesConsultar";
                  });
                } else if (data.msg == "erro") {
                  swal("Erro", "Erro ao realizar a ação!", "error");
                }
              }
            });
          }

        }
      );
    } else {
      swal({
        title: "Deseja salvar?",
        text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, pode salvar!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          $.ajax({
            type: "POST",
            url: base_url + 'Cadastros/Parcerias/parceriasValidar',
            data: {
              'idParceria': idParceria,
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Ação realizada!",
                }, function () {
                  window.location.href = base_url + "Configuracoes/Permissoes/permissoesConsultar";
                });
              } else if (data.msg == "erro") {
                swal("Erro", "Erro ao realizar a ação!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
        }
      });
    }
  });

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });
};
