/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
	var base_url = window.location.origin + "/";
	var table = $('#pessoas').DataTable({
		"language": {
			"sEmptyTable": "Nenhum registro encontrado",
			"sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
			"sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
			"sInfoFiltered": "(Filtrados de _MAX_ registros)",
			"sInfoPostFix": "",
			"sInfoThousands": ".",
			"sLengthMenu": "_MENU_ resultados por página",
			"sLoadingRecords": "Carregando...",
			"sProcessing": "Processando...",
			"sZeroRecords": "Nenhum registro encontrado",
			"sSearch": "Pesquisar",
			"oPaginate": {
				"sNext": "Próximo",
				"sPrevious": "Anterior",
				"sFirst": "Primeiro",
				"sLast": "Último"
			},
			"oAria": {
				"sSortAscending": ": Ordenar colunas de forma ascendente",
				"sSortDescending": ": Ordenar colunas de forma descendente"
			}
		},
		scrollX: true
	});

	$('#pessoas tbody').on('click', 'tr', function () {
		$(this).toggleClass('selected');
	});

	$('#gravar_pessoas').click(function () {
		swal({
			title: "Deseja salvar?",
			text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
			type: "warning",
			showCancelButton: true,
			confirmButtonColor: "#1E9FF2",
			confirmButtonText: "Sim, pode salvar!",
			cancelButtonText: "Não, cancele!",
			closeOnConfirm: true,
			closeOnCancel: false
		}, function (isConfirm) {
			if (isConfirm) {
				$('#frmPessoas_cadastro').submit();
			} else {
				swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
			}
		});
	});

	/** Design da tela */

	/* Esconde os elementos da tela */

	$('.fisica').hide();
	$('.juridica').hide();

	$('#pessoas_tipo').on('change', function () {
		var tipo = $(this).val();
		if (tipo == "F") {
			/** Exibindo campos pessoa física */
			$('.juridica').hide();
			$('.fisica').show();
			/* Adicionando regras de validação*/
			$(".juridica").prop("disabled", true);
			$(".fisica").prop("disabled", false);
		}
		if (tipo == "J") {
			/** Exibindo campos pessoa jurídica */
			$('.fisica').hide();
			$('.juridica').show();
			/* Adicionando regras de validação*/
			$(".fisica").prop("disabled", true);
			$(".juridica").prop("disabled", false);
		}

		if (tipo == "") {
			$('.fisica').hide();
			$('.juridica').hide();
		}
	});

	/**Carregamento campos em edição obs:não precisa de click */

	var tipo = $('#pessoas_tipo').val();
	if (tipo == "F") {
		/** Exibindo campos pessoa física */
		$('.juridica').hide();
		$('.fisica').show();
		/* Adicionando regras de validação*/
		$(".juridica").prop("disabled", true);
		$(".fisica").prop("disabled", false);
	}
	if (tipo == "J") {
		/** Exibindo campos pessoa jurídica */
		$('.fisica').hide();
		$('.juridica').show();
		/* Adicionando regras de validação*/
		$(".fisica").prop("disabled", true);
		$(".juridica").prop("disabled", false);
	}

	/** Webservice VIACEP */

	$("#pessoas_cep").blur(function () {
		//Nova variável "cep" somente com dígitos.
		var cep = $(this).val().replace(/\D/g, '');

		//Verifica se campo cep possui valor informado.
		if (cep != "") {

			//Expressão regular para validar o CEP.
			var validacep = /^[0-9]{8}$/;

			//Valida o formato do CEP.
			if (validacep.test(cep)) {

				//Preenche os campos com "..." enquanto consulta webservice.
				$("#pessoas_logradouro").val("...");
				$("#pessoas_bairro").val("...");
				$("#pessoas_cidade").val("...");
				$("#pessoas_uf").val("...");
				$("#pessoas_ibge").val("...");

				//Consulta o webservice viacep.com.br/
				$.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

					if (!("erro" in dados)) {
						//Atualiza os campos com os valores da consulta.
						$("#pessoas_logradouro").val(dados.logradouro);
						$("#pessoas_bairro").val(dados.bairro);
						$("#pessoas_cidade").val(dados.localidade);
						$("#pessoas_uf").val(dados.uf);
						$("#pessoas_ibge").val(dados.ibge);
					} //end if.
					else {
						//CEP pesquisado não foi encontrado.
						swal("Erro!",
							"CEP não encontrado!")
					}
				});
			} //end if.
			else {
				//cep é inválido.
				swal("Erro!",
					"CEP inválido!")
			}
		} //end if.
	});


	/** Editar CPF e CNPJ se já houver na base de dados */
	$('#pessoas_cpf').blur(function () {
		var cpf = $(this).val();
		$.ajax({
			type: "POST",
			url: base_url + 'Cadastros/Pessoas/pessoasVerificarCPF_CNPJ',
			data: {
				'cpf_cnpj': cpf,
			},
			dataType: 'json',
			success: function (data) {
				if (data.length > 0) {
					if ($('#pessoas_id').val() != "") {
						if ($('#pessoas_id').val() != data[0].ID_PESSOA) {
							swal({
								title: "CPF Encontrado",
								text: "O CPF informado já existe na base de dados, deseja editá-lo?",
								type: "warning",
								showCancelButton: true,
								confirmButtonColor: "#1E9FF2",
								confirmButtonText: "Sim, desejo editar!",
								cancelButtonText: "Não, cancele!",
								closeOnConfirm: true,
								closeOnCancel: false
							}, function (isConfirm) {
								if (isConfirm) {
									window.location.replace(base_url + "Cadastros/Pessoas/pessoasEditar?id=" + btoa(data[0].ID_PESSOA));
								} else {
									swal("Cancelado", "Operação cancelada!", "error");
									$('#pessoas_cpf').val("");
								}
							});
						}
					} else {
						swal({
							title: "CPF Encontrado",
							text: "O CPF informado já existe na base de dados, deseja editá-lo?",
							type: "warning",
							showCancelButton: true,
							confirmButtonColor: "#1E9FF2",
							confirmButtonText: "Sim, desejo editar!",
							cancelButtonText: "Não, cancele!",
							closeOnConfirm: true,
							closeOnCancel: false
						}, function (isConfirm) {
							if (isConfirm) {
								window.location.replace(base_url + "Cadastros/Pessoas/pessoasEditar?id=" + btoa(data[0].ID_PESSOA));
							} else {
								swal("Cancelado", "Operação cancelada!", "error");
								$('#pessoas_cpf').val("");
							}
						});
					}
				}
			}
		});
	});

	$('#pessoas_cnpj').blur(function () {
		var cnpj = $(this).val();
		$.ajax({
			type: "POST",
			url: base_url + 'Cadastros/Pessoas/pessoasVerficarCPF_CNPJ',
			data: {
				'cpf_cnpj': cnpj,
			},
			dataType: 'json',
			success: function (data) {
				if (data.length > 0) {
					if ($('#pessoas_id').val() != "") {
						if ($('#pessoas_id').val() != data[0].ID_PESSOA) {
							swal({
								title: "CNPJ Encontrado",
								text: "O CNPJ informado já existe na base de dados, deseja editá-lo?",
								type: "warning",
								showCancelButton: true,
								confirmButtonColor: "#1E9FF2",
								confirmButtonText: "Sim, desejo editar!",
								cancelButtonText: "Não, cancele!",
								closeOnConfirm: true,
								closeOnCancel: false
							}, function (isConfirm) {
								if (isConfirm) {
									window.location.replace(base_url + "Cadastros/Pessoas/pessoasEditar?id=" + btoa(data[0].ID_PESSOA));
								} else {
									swal("Cancelado", "Operação cancelada!", "error");
									$('#pessoas_cnpj').val("");
								}
							});
						}
					} else {
						swal({
							title: "CNPJ Encontrado",
							text: "O CNPJ informado já existe na base de dados, deseja editá-lo?",
							type: "warning",
							showCancelButton: true,
							confirmButtonColor: "#1E9FF2",
							confirmButtonText: "Sim, desejo editar!",
							cancelButtonText: "Não, cancele!",
							closeOnConfirm: true,
							closeOnCancel: false
						}, function (isConfirm) {
							if (isConfirm) {
								window.location.replace(base_url + "Cadastros/Pessoas/pessoasEditar?id=" + btoa(data[0].ID_PESSOA));
							} else {
								swal("Cancelado", "Operação cancelada!", "error");
								$('#pessoas_cnpj').val("");
							}
						});
					}
				}
			}
		});
	});

	$('#pessoas_cnpj').blur(function (event) {
		var cnpj = $(this).val().replace(/\D/g, '');
		$.ajax({
			url: 'https://www.receitaws.com.br/v1/cnpj/' + cnpj + '',
			type: 'GET',
			crossDomain: true,
			dataType: 'jsonp',
			success: function (dados) {
				$('#pessoas_razao_social').val(dados.nome);
				$('#pessoas_nome_fantasia').val(dados.fantasia);
				$('#pessoas_cidade').val(dados.municipio);
				$('#pessoas_uf').val(dados.uf);
				$('#pessoas_logradouro').val(dados.logradouro);
				$('#pessoas_numero').val(dados.numero);
				$('#pessoas_bairro').val(dados.bairro);
				$('#pessoas_cep').val(dados.cep);
				var cep = dados.cep.replace(/\D/g, '');
				$.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (data) {

					if (!("erro" in data)) {
						//Atualiza os campos com os valores da consulta.
						$("#pessoas_ibge").val(data.ibge);
					} //end if.
					else {
						//CEP pesquisado não foi encontrado.
						swal("Erro!",
							"CEP não encontrado!")
					}
				});
				$('#pessoas_email').val(dados.email);
				$('#pessoas_telefone01').val(dados.telefone);
			}
		});
	});

	/** Limpa e gera pesquisa */
	$('#limpafrmpesquisa').click(function () {
		$("#frm_pesquisa")[0].reset();
		$('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
		$(":checkbox").prop('checked', false);
		$(':checkbox').find('checked').remove();
	});
	$('#enviafrmpesquisa').click(function () {
		$("#frm_pesquisa")[0].submit();
	});

	$('#pessoas_cep').blur(function () {
		if ($('#pessoas_cep').val() != '') {
			$.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#pessoas_logradouro').val() + "," + $('#pessoas_numero').val() + $('#pessoas_cidade').val() + "-" + $('#pessoas_uf').val() + "," + $('#pessoas_cep').val() + "&key=AIzaSyCBYsNVZ27I4Bcqnxtrb33LKR6PNh8cxss", function (dados) {

				if (!("erro" in dados)) {
					deleteMarkers();
					addMarker(dados.results[0].geometry.location);
					addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
				}
			});
		}
	});

	$('#pessoas_cidade').blur(function (event) {
		if ($('#pessoas_cidade').val() != '') {
			$.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#pessoas_logradouro').val() + "," + $('#pessoas_numero').val() + $('#pessoas_cidade').val() + "-" + $('#pessoas_uf').val() + "," + $('#pessoas_cep').val() + "&key=AIzaSyCBYsNVZ27I4Bcqnxtrb33LKR6PNh8cxss", function (dados) {

				if (!("erro" in dados)) {
					deleteMarkers();
					addMarker(dados.results[0].geometry.location);
					addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
				}
			});
		}
	});

	$('#pessoas_uf').blur(function (event) {
		if ($('#pessoas_uf').val() != '') {
			$.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#pessoas_logradouro').val() + "," + $('#pessoas_numero').val() + $('#pessoas_cidade').val() + "-" + $('#pessoas_uf').val() + "," + $('#pessoas_cep').val() + "&key=AIzaSyCBYsNVZ27I4Bcqnxtrb33LKR6PNh8cxss", function (dados) {

				if (!("erro" in dados)) {
					deleteMarkers();
					addMarker(dados.results[0].geometry.location);
					addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
				}
			});
		}
	});

	$('#pessoas_logradouro').blur(function (event) {
		if ($('#pessoas_logradouro').val() != '') {
			$.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#pessoas_logradouro').val() + "," + $('#pessoas_numero').val() + $('#pessoas_cidade').val() + "-" + $('#pessoas_uf').val() + "," + $('#pessoas_cep').val() + "&key=AIzaSyCBYsNVZ27I4Bcqnxtrb33LKR6PNh8cxss", function (dados) {

				if (!("erro" in dados)) {
					deleteMarkers();
					addMarker(dados.results[0].geometry.location);
					addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
				}
			});
		}
	});

	$('#pessoas_numero').blur(function (event) {
		if ($('#pessoas_numero').val() != '') {
			$.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#pessoas_logradouro').val() + "," + $('#pessoas_numero').val() + $('#pessoas_cidade').val() + "-" + $('#pessoas_uf').val() + "," + $('#pessoas_cep').val() + "&key=AIzaSyCBYsNVZ27I4Bcqnxtrb33LKR6PNh8cxss", function (dados) {

				if (!("erro" in dados)) {
					deleteMarkers();
					addMarker(dados.results[0].geometry.location);
					addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
				}
			});
		}
	});

	var geocode = $('#geocode').val();

	if (geocode != null && geocode != "") {
		$.getJSON("https://maps.googleapis.com/maps/api/geocode/json?latlng=" + geocode + "&key=AIzaSyCBYsNVZ27I4Bcqnxtrb33LKR6PNh8cxss", function (dados) {

			if (!("erro" in dados)) {
				//Adicionar marcador no maps
				addMarker(dados.results[0].geometry.location);
			} //end if.
			else {
				alert('erro ao carregar mapa');
				//CEP pesquisado não foi encontrado.
			}
		});
	}
};