/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var table = $('#propostas').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    "pageLength": 50,
    scrollX: true
  });

  $('#propostas tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  $('#gravar_proposta').click(function () {
    swal({
      title: "Deseja salvar?",
      text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode salvar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        var linha_original = $('#prod_original').val();
        var linha_conceito = $('#prod_conceito').val();
        var linha_premium = $('#prod_premium').val();
        var fabricao = $('#propostas_prazo').val();
        var montagem = $('#propostas_prazo_mont').val();
        var garantia = $('#propostas_garantia').val();
        var detalhes = CKEDITOR.instances["propostas_descricao"].getData();
        var formas = CKEDITOR.instances["propostas_formas"].getData();
        var id = $('#propostas_id').val();
        var solicitacao = $('#propostas_solicitacao').val();
        var i, linhasDaTabela = new Array();
        for (i = 0; i < $('.desc_produto').length; i++) {
          linhasDaTabela[i] = new Object();
          linhasDaTabela[i].desc_produto = $('.desc_produto')[i].value;
          linhasDaTabela[i].linha_prod = $('.linha_prod')[i].value;
          linhasDaTabela[i].qtd_produto = $('.qtd_produto')[i].value;
          linhasDaTabela[i].val_produto = $('.val_produto')[i].value;
          linhasDaTabela[i].tot_produto = $('.tot_produto')[i].value;
        }
        $.ajax({
          url: base_url + 'Orcamento/Propostas/setProposta',
          type: 'POST',
          dataType: 'json',
          data: {
            'id': id,
            'solicitacao': solicitacao,
            'arr': linhasDaTabela,
            'linha_original': linha_original,
            'linha_conceito': linha_conceito,
            'linha_premium': linha_premium,
            'fabricao': fabricao,
            'montagem': montagem,
            'garantia': garantia,
            'detalhes': detalhes,
            'formas': formas,
            'gravar': 'ok'
          },
          success: function (data) {
            if (data.msg == "sucesso") {
              swal({
                title: "Sucesso",
                type: "success",
                confirmButtonText: "Ok",
                text: "Proposta criada!",
              }, function () {
                location.reload();
              });
            } else {
              swal("Erro", "Erro ao adicionar serviços!", "error");
            }
          }
        });
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  });

  $("#propostas button").click(function () {
    var classe = $(this).attr('class');
    if (classe == "btn bg-red btn-list-icon") {
      var id = $(this).attr('id');
      swal({
        title: "Deseja excluir?",
        text: "Ao excluir, o mesmo será removido permanentemente",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, pode excluir!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          $.ajax({
            type: "POST",
            url: base_url + 'Orcamento/Propostas/propostasExcluir',
            data: {
              'id': id
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Proposta excluída!",
                }, function () {
                  location.reload();
                });
              } else {
                swal("Erro", "Erro ao excluir!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada!", "error");
        }
      });
    } else if (classe == "btn bg-purple btn-list-icon") {
      var solicitacao = GetURLParameter('solicitacao');
      var id = $(this).attr('id');
      swal({
        title: "Deseja aceitar?",
        text: "Ao aceitar a proposta, a mesma será permanente",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, pode validar!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          $.ajax({
            type: "POST",
            url: base_url + 'Orcamento/Propostas/propostasAceitar',
            data: {
              'id': id,
              'solicitacao': solicitacao
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Proposta aceita!",
                }, function () {
                  location.reload();
                });
              } else {
                swal("Erro", "Erro ao aceitar!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada!", "error");
        }
      });
    }

  });

  $(document).on('click', 'a.remove', function () {
    $(this).closest('div.conteudo').remove();
  });

  $('#add_produtos').click(function () {
    $('#frmPropostas_cadastro .content').append('<div class="row conteudo">' +
      '<div class="col-md-3">' +
      '<div class="form-group">' +
      '<h5>Descrição<span class="text-danger">*</span></h5>' +
      '<div class="controls">' +
      '<input type="text" name="produto_desc[]" id="produto_desc" class="form-control desc_produto">' +
      '</div>' +
      '</div>' +
      '</div>' +
      '<div class="col-md-2">' +
      '<div class="form-group">' +
      '<h5>Linha<span class="text-danger">*</span></h5>' +
      '<div class="controls">' +
      '<select class="form-control linha_prod" name="prod_linha" id="prod_linha">' +
      '<option value="1">Original</option>' +
      '<option value="2">Conceito</option>' +
      '<option value="3">Premium</option>' +
      '</select>' +
      '</div>' +
      '</div>' +
      '</div>' +
      '<div class="col-md-2">' +
      '<div class="form-group">' +
      '<h5>Qtd.<span class="text-danger">*</span></h5>' +
      '<div class="controls">' +
      '<input type="text" name="produto_qtd[]" id="produto_qtd" class="form-control qtd_produto">' +
      '</div>' +
      '</div>' +
      '</div>' +
      '<div class="col-md-2">' +
      '<div class="form-group">' +
      '<h5>Valor Un<span class="text-danger">*</span></h5>' +
      '<div class="controls">' +
      '<input type="text" name="produto_valor[]" id="produto_valor" class="form-control dinheiro val_produto">' +
      '<input type="hidden" name="id[]" id="id" class="form-control id_produto">' +
      '</div>' +
      '</div>' +
      '</div>' +
      '<div class="col-md-2">' +
      '<div class="form-group">' +
      '<h5>Valor Total<span class="text-danger">*</span></h5>' +
      '<div class="controls">' +
      '<input type="text" name="produto_valor[]" id="produto_valor" class="form-control dinheiro tot_produto">' +
      '<input type="hidden" name="id[]" id="id" class="form-control id_produto">' +
      '</div>' +
      '</div>' +
      '</div>' +
      '<div class="col-md-1">' +
      '<div class="form-group">' +
      '<h5>&nbsp;</h5>' +
      '<div class="controls">' +
      '<a class="remove"><span style="color:red;widtd:100%;height:100%" class="fa fa-trash"></span></a>' +
      '</div>' +
      '</div>' +
      '</div>' +
      '</div>');

    mascaras();

  });

  // Replace the <textarea id="parametro_layout"> with a CKEditor
  // instance, using default configuration.
  CKEDITOR.replace('propostas_descricao')
  CKEDITOR.replace('propostas_formas')
  //bootstrap WYSIHTML5 - text editor
  $('.textarea').wysihtml5();

  function mascaras() {
    $('.datafmtbr').inputmask('99/99/9999');
    $('.datafmtbr').datepicker({
      autoclose: true,
      format: 'dd.mm.yyyy',
      language: 'pt-BR'
    });
    $('.datafmtnf').inputmask('99/9999');
    $('.datafmtnf').datepicker({
      autoclose: true,
      format: 'mm.yyyy',
      language: 'pt-BR'
    });

    $('.horafmtbr').inputmask('99:99');


    $('.competencia').inputmask('99/9999');

    $('.mac').inputmask('##:##:##:##:##:##');
    $('.ip').inputmask('999.999.999.999');
    $('.cpf').inputmask('999.999.999-99');
    $('.cnpj').inputmask('99.999.999/9999-99');
    $('.cep').inputmask('99999-999');
    $('.placa').inputmask('AAA-9999');

    $('.telefone').inputmask('(99)99999-9999');

    $('.dinheiro').maskMoney({

      prefix: 'R$ ',

      allowNegative: true,

      thousands: '',

      decimal: ',',

      affixesStay: false

    });
  }

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });
};
